﻿
Partial Class deleteswap
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site infor class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    'var to store the swap number
    Dim SwapNo As Integer

    Protected Sub btnNo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnNo.Click
        'redirect back to the swap manager
        Response.Redirect("swapmanager.aspx")
    End Sub

    Protected Sub btnYes_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnYes.Click
        'delete the swap
        Call DeleteSwap()
        'clear the list box indexes
        Call ClearIndexes()
        'redirect back to the swap manager
        Response.Redirect("swapmanager.aspx")
    End Sub

    Sub DeleteSwap()
        'this sub deletes the swap identified by swapno
        '
        'find the record in the database
        Dim ASwap As New DatabaseTable("dvd.mdb", "select * from swap where swapno=" & SwapNo, "#PN", "#PW")
        'if the record is found
        If ASwap.Count = 1 Then
            'remove the record
            ASwap.RemoveRecord(0)
            'save the changes
            ASwap.SaveChanges()
        End If
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'this event runs when the page loads
        'check that the user is logged in
        Call CheckLogin()
        'get the swap no for deletion
        SwapNo = Session("SwapNo")
    End Sub

    Sub CheckLogin()
        'this sub tests that the user has logged in correctly
        'if not then they are redirected to the main page
        'get the details of the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user object is not set up correctly
        If TheCurrentUser Is Nothing Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
        'if the current user is not authenticated
        If TheCurrentUser.Authenticated = False Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
    End Sub

    Sub ClearIndexes()
        'this sub clears the indexes stored in the session object
        Session("SwapIndex") = -1
        Session("OfferIndex") = -1
    End Sub

End Class
